{*
 * Projecte Fressa a LINKAT
 * GLOBUS3
 * Data inici: 28/08/2002
 * Ultim dia:  16/05/2009
 *
 * @author Jordi Lagares Roset "jlagares@xtec.cat - www.lagares.org"
 * amb el suport del Departament d'Educacio de la Generalitat de Catalunya
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details (see the LICENSE file).
 *}

{***********************************************************************
  01 - 28/08/02 -
  02 - 31/12/02 - He posat al quadre about box projecte Fressa 2002
  03 - 31/12/02 - He posat una nova opci d'exercicis d'intensitat, Grisos
  04 - 31/12/02 - He posat l'envolvent LPC a l'espectroscopi
  05 - 31/12/02 - He posat la possibilitat dels clculs dels espectres amb Premfasis i finestra de Hamming amb el checkButton Mgic
  06 - 01/01/03 - He posat el men grisos amb el de globus ja que li toca all
  07 - 01/01/03 - Les linies de l'envolvent no es posaven a 0 si s'activava l'espectre del professor. Ho he posat a zero
  08 - 01/01/03 - Les linies de l'envolvent no es calculaven si no hi havia el checkbox.Envolvent checked
  09 - 02/01/03 - He posat el CheckBoxMagic.Enabled noms quan est activada l'entrada de so
  10 - 25/01/03 - Versi en Euskera
  11 - 04/02/03 - Modificacions versi Euskera
  12 - 14/02/03 - He fet posat graella horitzontal a l'oscil.loscopi marcant els Decibels
  13 - 14/02/03 - He fet la finestra de l'espectroscopi una mica ms gran (800 pxels) i he fet que marqus els Decibels de la ona al moure la rata
  14 - 14/02/03 - He posat l'opci clcul automtic de la freqncia en modus oscil.loscopi per la pista 1
  15 - 14/02/03 - He fet que quan hi ha l'oscil.loscopi no es pugui activar ni el chekbox FFT ni el Envolvent
  16 - 14/02/03 - He posat un Panel a sota. Hi he posat els Labels informatius i he posat un nou chekbox, Clcul automtic de la freqncia
  17 - 15/02/03 - He fet de manera que quan es calculi la freqncia noms es pugui fer servir la pista de dalt
  18 - 15/02/03 - Quan es calcula la freqncia es fa que l'ona es dibuixi al principi en el mxim i l'oscil.loscop es veu uniforme
  19 - 15/02/03 - He fet que calculi l'Energia en Decibels de tota l'ona i quan ens moguem pel panell de sota faci el mateix que al moure's pel panell de sobre
  20 - 15/02/03 - He tret que quan es cliqui comenci l'ona en el punt de clicar amb clcul automtic de le freqncia activat. Problemes amb el clcul automtic de la freqncia. Hi comena a no tenir sentit per aquesta mateixa opci
  21 - 15/02/03 - He fet que amb el clic dret es pari l'entrada de so. Com els botons Parar
  22 - 15/02/03 - He fet que quan hi ha clcul automtic de la freqncia la FFT noms hi ha la pista 1
  23 - 17/02/03 - He fet una nova opci d'exercici d'aguantar un so. L'Atractor
  24 - 30/03/03 - Versi en galleg
  25 - 22/04/03 - Versi en portugus
  26 - 09/05/03 - A petici de les del Credag he fet una versi manual del reconeixement de fonemes. Menu Fonemes. Per que surti el foneme cal prmer clic o una tecla.
  27 - 09/05/03 - En el quadre, Vanvi de Parmetres he posat un bot per anar a controlar en programa Nivell de Micrfon.
  28 - 14/05/03 - Avui al Credag he notat que el bot canvi de parmetres tenia un comportament extrany amb el down en el Reconeixement manual de fonemes. He hagut de posar el GroupIndex=0 del bot i ho he fet en un parell ms de finestes.
  29 - 14/05/03 - El CheckBoxGrandaria del Reconeixement manual de fonemes l'he deixat checked per defecte. Experincia d'avui al Credag.
  30 - 14/05/03 - El CheckBoxGrandaria l'he deixat checked per defecte. Experincia d'avui al Credag.
  31 - 22/09/03 - En castell posava viage en lloc de viaje
  32 - 18/11/04 - Esttica nova del quadre About Box amb Projecte Fressa 2004 i lo altre en 3 dimensions
  33 - 20/11/04 - He canviat el nom per Globus 3
  34 - 21/11/04 - He posat el men Comparaci de patrons (MenuEspectroscopi LPC). Calcula els patrons calculant l'espectre LPC amb diferents configuracions
  35 - 28/11/04 - He posat el men Freqncia. Calcula la freqncia a partir del Cepstrum
  36 - 09/12/04 - He canviat al directori Projecte Fressa 2005
  37 - 09/12/04 - He posat el Logo Projecte Fressa 2005
  38 - 09/12/04 - He els mens i els missatges del FormEspectroscopiLPC (Comparaci de patrons) en castell quan el men catal no est activat.
  39 - 09/12/04 - El bot vocals del FormEspectroscopiLPC en castell escriu AEIOU i esborra els no fets servir i en catal tamb
  40 - 09/12/04 - El FormFrequencia l'he tradut al castell el poc que tenia d'escrits
  41 - 10/12/04 - En el FormFrequencia he fet l'opci escala logartmica
  42 - 10/12/04 - En el FormFrequencia he fet que quan reb so no repinti, que pinti, esborrant noms la fletxa que s el que canvia
  43 - 10/12/04 - En el FormFrequencia he dibuixat un piano per no m'acaba de convncer
  44 - 11/12/04 - En el FormFrequencia he dibuixat un altre piano, est millor, per per algunes notes no es`t exactament col.locat
  45 - 11/12/04 - He descobert un fallo en el procediment TornarNota del UniTools, el Si sempre el deia d'una octava superior. Ho he corregit
  46 - 12/12/04 - En el FormFrequencia he fet que es mostri la freqncia on es troba el cursor
  47 - 12/12/04 - En el FormFrequencia he canviat la fletxa dibuixada per un dibuix d'una fletxa
  48 - 12/12/04 - En el FormFrequencia he fet que el primer cop que detecti so no calculi la freqncia. Ho faci a partir del segon ja que el primer normalment es gaireb un so sord i moltes vegades no t freqncia definida
  49 - 12/12/04 - En el FormFrequencia he canviat dues vegades el sistema de controlar que no surti una freqncia un mltiple o divisor de la freqncia real
  50 - 13/12/04 - En el FormFrequencia he fet que el clcul de la freqncia sigui una funci a part del procedure Pintar
  51 - 13/12/04 - En el FormFrequencia he fet l'opci que indiqui la freqncia noms per notes, hi ha la possibilitat de discretitzar la indicaci de freqncia
  52 - 14/12/04 - En el FormFrequencia per calcular la freqncia he fet no conti els sons sords (SS), De moment que la RelacioEnergies<15 ja que les is les detecta com a sords
  53 - 14/12/04 - En el FormFrequencia he fet que es marqui la freqncia mxima i mnima
  54 - 15/12/04 - En el FormFrequencia he fet una modificaci on marcava la freqncia mxima i mnima ja que a vegades desapareixia
  55 - 15/12/04 - En el FormFrequencia he deixat la possibilitat de FrequenciaDeMostreigEntradaSo:=22050, i recordo que GrandariaBytesBufferEntradaDeSo:=1024; en lloc de 512. Ho he provat i sembla que funciona ms malament que a 11025
  56 - 18/12/04 - El MenuFonemes.Caption i en el FormReconeixementManualDeFonemes.CheckBoxGrandaria.Caption, en castell
  57 - 18/12/04 - El BitBtnMicrofon.Caption en castell
  58 - 19/12/04 - FormSonograma
  59 - 21/12/04 - El FormEspectroscopi.CheckBoxCalculAutomaticFrequencia.Caption en castell
  60 - 21/12/04 - En el FormEspectroscopi he posat el CheckBoxRapid que permet IniciarDadesUnitEntradaSo(512) en ms de IniciarDadesUnitEntradaSo(1024)
  61 - 21/12/04 - A l'AboutBOx hi he posat dedicat als meus pares
  62 - 21/12/04 - He posat al FormSonograma CheckBoxCircular, si est activat no es para al final i torna a comenar
  63 - 21/12/04 - He posat NumeroQuoeficientsLPC:=20; en lloc de 13 igual que el FormEspectroscopi
  64 - 21/12/04 - He posat al FormSonograma CheckBoxEscalaY perqu surtin uns eixos horitzontals Y
  65 - 21/12/04 - He posat al NumeroQuoeficientsLPC:=20; en l'ESpectroscopiLPC
  66 - 21/12/04 - FormEspectroscopiLPC.FormClose he fet que es pari l'entrada de so
  67 - 21/12/04 - FormEspectroscopiLPC. He fet que surti Hertz en l'eix X
  68 - 21/12/04 - FormSonograma en lloc de fer servir Canvas.Pen.Color:=RGB(r,r,r) per canviar el color ho faig havent creat for i:=0 to 255 do Pens[i]:=CreatePen(ps_Solid,0,RGB(i,i,i)); i fent servir SelectObject(ScreenDC,Pens[r]); prviament ScreenDC:=GetDC(Handle); i en lloc de Canvas.LineTo(i,Comodi+n); posar LineTo(ScreenDC,i,Comodi+n); El temps per pintar-ho tot es divideix per 3 de 3328 ms passa a 1141 ms
  69 - 22/12/04 - FormSonograma. El punt 68 ho he implementat tamb en el dibuix de sonograma quen ho pinta en temps real en el WMWIMDATA
  70 - 22/12/04 - FormSonograma. He fet experiments amb el punt 69. Havia tret el R, per li he tornat a posar, sembla que va un pel ms depressa, he modificat el lloc on hi havia el ReleaseDC ja que encallava el procs de dibuix en temps real. He fet experiemnts de temps i ara triga en capturar el so igual en aquesta versi 70 que la 67. Crec que es pot dir que s'ha optimitzat el dibuixar fent servir els Pens i el LineTo i MoveTo del Windows. Amb la configuraci actual es captura uns 6 segons de so per pista.
  71 - 22/12/04 - FormSonograma. He posat ValorMaximDelSo>5*256 ja que les S no les detectava. He fet experiments amb GrandariaInstant:=256 en lloc de 512. Fa com unes ratlles entre mig degut a la variabilitat. Diria que 512 uniformitza millor i defineix millor els formants ???
  72 - 22/12/04 - FormSonograma. La lnea Vermella l'he fet amb MoveToEx(ScreenDC,...) etc ja que al mig de tant en tan s'encallava. Diria que no m'ho ha fet ms
  73 - 22/12/04 - FormSonograma. Les Linees grises de l'eix Y les he fet amb MoveToEx(ScreenDC,...) etc perqu penso podria portar problemes
  74 - 22/12/04 - FormSonograma. Els nmeros de l'eix Y els he posat en color Gris en lloc de negre
  75 - 23/12/04 - FormSonograma. La linea vermella la faig dibuixar un pixel ms a la dreta i es veu millor.
  76 - 23/12/04 - FormSonograma. El MouseMove indica la freqncia i la nota d'on tenim la rata
  77 - 23/12/04 - He fet el men Angls
  78 - 24/12/04 - FormEspectroscopiLPC. He posat el CheckBoxNoRepintar
  79 - 24/12/04 - He posat el men Plasma que crida un programa extern que es veu un plasma
  80 - 25/12/04 - He posat if not FileExists('plasma.exe') then MenuPlasma.Visible:=false;
  81 - 25/12/04 - FormPlasma. He tret el but copiar a la carpeta
  82 - 25/12/04 - FormSonograma. He posat el fons dels nmeros transparent, Canvas.Brush.Style:=bsClear;
  83 - 26/12/04 - FormFractal. He posat un nou men, Fractal Mandelbrot,
  84 - 27/12/04 - FormFractal. He posat CheckBoxNoIniciar. Si s'activa no s'esborra al no tenir so
  85 - 28/12/04 - FormSonograma. He posat girat l'eix Y. Les freqncies baixes estan a baix, al revs de com ho he fet sempre, espero acostuma'm-hi
  86 - 28/12/04 - FormAtractor. He posat CheckBoxNoIniciar. Si s'activa no s'esborra al no tenir so
  87 - 28/12/04 - FormSonograma. Aprofita la pantalla fins a les pantalles de 1600 d'amplada
  88 - 28/12/04 - FormFractal. He posat try ... except end a tot el dibuix ja que he vist que en altres casos es penjava
  89 - 29/12/04 - FormPlasma. He fet que el programa Plasma.exe necessiti el parmetre globus3P987654321 per a que funcioni
  90 - 29/12/04 - FormSonograma. SpinEditVelocitat posar diferents velocitats per ordinadors ms lents
  91 - 30/12/04 - He canviat l'INI de globus 2 a globus 3
  92 - 30/12/04 - FormEspectroscopiLPC. La seva configuraci s guarda a l'.INI
  93 - 30/12/04 - FormSonograma. La seva configuraci s guarda a l'.INI
  94 - 30/12/04 - FormSonograma. SpinEditNumeroQuoeficients entre 5 i 24 per defecte 20
  95 - 30/12/04 - FormEspectroscopiLPC. He fet ms petit l'espai per posar les vocals per que hi quepiga ms coses i he fet que sense MenuEscalaYDecibels.Checked les linies de comparaci de patrons es divideixin per 10 per no barrejar-les amb els patrons
  96 - 30/12/04 - FormEspectroscopiLPC. SpinEditNumeroQuoeficients entre 5 i 24 per defecte 20
  97 - 30/12/04 - FormSonograma. He posat if not HeDeRepintar then exit; en el FormPaint i poso HeDeRepintar:=false; quan captura so ja que dna la sensaci que en alguns casos torna a pintar mentre rep so
  98 - 30/12/04 - FormSonograma. Es pot guardar el so de les dues pistes
  99 - 31/12/04 - FormGlobus.CheckBoxDecibels guardo el seu estat a l'INI
  100 - 31/12/04 - FormSonograma. He fet GuardarPista(Pista:integer); per guardar les dues pistes
  101 - 31/12/04 - FormSonograma. He fet SpinEditNumeroQuoeficients.Enabled:=false; quan s'estigui capturant so
  102 - 31/12/04 - FormSonograma. Si es canvia SpinEditNumeroQuoeficients s recalcula el sonograma
  103 - 01/01/05 - FormSonograma. En cas de no poder obrir l'arxiu dna un missatge d'error. Missatges[1]:='No puc obrir el fitxer o el fitxer no cont dades Globus-Sonograma';
  104 - 01/01/05 - FormEspectroscopiLPC. He canviat Numeros:array[0..100] of NumerosPerCalcular; per EntersPerCalcular;
  105 - 02/01/05 - FormEspectroscopiLPC. Pot desar i obrir en un fitxer els patrons
  106 - 02/01/05 - FormEspectroscopiLPC. He posat CheckBoxMostrarSoReconegut.
  107 - 02/01/05 - FormEspectroscopiLPC. He posat ValorMinimDeSo:=StrToInt(FormCanviDeParametres.EditMinim.Text)*256;
  108 - 02/01/05 - FormEspectroscopiLPC. He posat el bot FormCanviDeParametres.ShowModal; degut a la versi anterior 107
  109 - 03/01/05 - FormCanviDeparametres. Guardo els seus valors a l'INI
  110 - 03/01/05 - FormCanviDeparametres. El but cancel.lar ara fa aix ja que abans feia el mateix que el D'acord
  111 - 03/01/05 - FormSonograma. He posat el bot FormCanviDeParametres.ShowModal; ja que ValorMinimDeSo:=(StrToInt(FormCanviDeParametres.EditMinim.Text)*256) div 4;
  112 - 03/01/05 - FormEspectroscopiLPC. En la escala de Mel, fer patrons a partir d'ella.
  113 - 03/01/05 - FormEspectroscopiLPC. He posat CheckBoxEscalaMelLineal, que no ha de sortir en la versi definitiva, per fer estudis sobre l'eficcia de la versi 112
  114 - 04/01/05 - FormEspectroscopiLPC. He posat VocalReconegudaAnterior que es pinta al principi del procediment Paint perqu es vegi ms estona la lletra reconeguda
  115 - 04/01/05 - FormEspectroscopiLPC. He posat  NumeroPuntsFuncioDeTransferencia:=256;
      - 04/01/05 - FormEspectroscopiLPC. He si en CheckBoxEscalaMelLineal canvio NumeroPuntsFuncioDeTransferencia:=256; per un valor ms petit lltim punt ho fa malament. Agafa com a valor l'ltim del so gravat ms recent. Per arreglar-ho no canvio aquest valor
  116 - 04/01/05 - FormEspectroscopiLPC. He tret el CheckBoxEscalaMelLineal. Tot es fa amb aix activat.
  117 - 04/01/05 - FormEspectroscopiLPC. He reordenat els CheckBox i hi he posat una separaci pel MenuNormalitzarPerMaxim ja que s l'nic que noms ofereix un aspecte esttic
  118 - 05/01/05 - FormFrecuencia. He posat ValorMinimDeSo:=StrToInt(FormCanviDeParametres.EditMinim.Text)*256;
  119 - 05/01/05 - FormFrecuencia. Hi havia un error ja que si CheckBoxEvolucio.Checked i es redimensionava la finestra es continuava la linea Evoluci. He posat if (PosicioLinea<600) and SpeedButtonEngegarParar.Down then ...
  120 - 05/01/05 - FormGlobus. He fet que amb el clic dret es pari l'entrada de so. Com els botons Parar. De fet s la versi 21 que no acabava de funcionar.
  121 - 05/01/05 - FormGrisos, FormArcDeSantMarti, FormJocRectangles, FormAtractor, FormFractal, FormViatgeEnGlobus, FormIntensitatDurada, FormFemMoureUnCotxe, FormCursa, FormEspectroscopi, FormEspectroscopiLPC, FormSonograma, FormFrequencia, FormReconeixementManualDeFonemes. He fet que amb el clic dret es pari l'entrada de so. Com els botons Parar.
  122 - 05/01/05 - FormEspectroscopiLPC. Clicant amb el bot esquerra congela la el patr
  123 - 05/01/05 - FormGlobus. He canviat una mica el comportament de la versi 120. El clic dret esborra el cercle marcat amb el clic esquerra. Per parar el programa cal tornar fer un altre clic dret o b fer-lo sense que hi hagi marcat cap cercle.
  124 - 05/01/05 - FormSonograma. Hi havia un error al pintar els eixos horitzontals on s'indica la freqncia. He fet la Procedure PintarEjes; que es fa servir en tots els casos
  125 - 05/01/05 - FormSonograma. He posat CheckBoxEscalaY.Enabled:=false; quan hi ha entrada de so ja que podia produir un malfuncionament
  126 - 07/01/05 - Amb el que m'ha enviat l'Alberto Cifuentes ja he fet la nova versi dels missatges en galleg i portugus
  127 - 07/01/05 - FormFrequencia. He canviat CaptionFinestra per FormPrincipal.MenuFrequencia.Caption ja que el ttol de la finestra sempre sortia en catal
  128 - 07/01/05 - FormSonograma. FormEspectroscopiLPC. Al guardar si es vol fer amb un fitxer amb el mateix demana confirmaci
  129 - 08/01/05 - FormSonograma. FormEspectroscopiLPC. El Hint de SpinEditNumeroQuoeficients posava Velocitat. Ho he canviat per Nmero de quoeficients
  130 - 08/01/05 - FormSonograma. He posat un nou bot que permet carregar un patr a la pista 2
  131 - 08/01/05 - FormSonograma. He posat que surti el ttol escrit del fitxer quan es carrega un fitxer de patrons
  132 - 08/01/05 - FormSonograma. Al gavar en la primera pista no esborra la segona
  133 - 12/01/05 - FormEspectroscopiLPC. He posat if CheckBoxNoRepintar.Checked then Pintar else Repaint; al SpeedButtonEngegarPararClick ja que repintava quan paravem i engegavem
  134 - 12/01/05 - FormEspectroscopiLPC. Al FormMouseMove he fet que indiqui la freqncia
  135 - 12/01/05 - FormEspectroscopiLPC. Si es clica amb el bot dret el LabelColorLinea reinicialitza a negre el color
  136 - 12/01/05 - Versi en Euskera
  137-b-21/07/08 - He posat el UnitEntradaDeSo, UnitDades, UnitCalculsLPC, UnitCalculsMatematics en el directori actual en lloc del directori Estudis Reconeixement de Veu/Clculs Matemtics en el so. I on posava WinTypes i WinProcs ho he canviat per Windows. M'ha fet descobrir aquestos problemes al passar-ho a Lazarus
  138-b-16/05/09 - El faig Open Source - Codi Obert (CO)
  139-b-16/05/09 - Canvio la grandria de la finestra principal perqu es vegi b en XP amb vista normal
  140-b-31/05/09 - He posat Projecte Fressa 2009
  141-b-14/07/12 - En el FormIntensitat durada he posat IniciarDadesUnitEntradaSo(512) en lloc de IniciarDadesUnitEntradaSo(128) ja que en W7 no ho podia parar amb el bot. Albacete Bajo Coste 2012
  142-b-19/07/12 - He posat projecte Fressa 2012
***********************************************************************}
{
  -Cal posar el clcul automtic de la freqncia a la pista 2.**
  -Cal calcular els Decibells amb la FFT** No s si cal
  -Cal posar el clcul automtic de la freqncia en la FFT
  -Cal calcular la freqncia de l'osciloscopi fent servir tamb el clcul FFT
}

unit UnitFormPrincipal;

{************************************************}
INTERFACE
{************************************************}

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  Menus;

type
  TFormPrincipal = class(TForm)
    MainMenu1: TMainMenu;
    MenuFitxer: TMenuItem;
    N1: TMenuItem;
    MenuSortir: TMenuItem;
    MenuQueVullFer: TMenuItem;
    MenuIntensitatDurada: TMenuItem;
    N2: TMenuItem;
    MenuEspectroscopi: TMenuItem;
    MenuGlobus: TMenuItem;
    N3: TMenuItem;
    N4: TMenuItem;
    MenuArcdeSantMarti: TMenuItem;
    MenuJocDelsRectangles: TMenuItem;
    MenuViatgeAmbGlobus: TMenuItem;
    MenuXupaXups: TMenuItem;
    N5: TMenuItem;
    MenuFemMoureUnCotxe: TMenuItem;
    MenuCursa: TMenuItem;
    MenuCanviarParametres: TMenuItem;
    MenuParlantDe: TMenuItem;
    MenuLlengua: TMenuItem;
    MenuCatala: TMenuItem;
    MenuCastellano: TMenuItem;
    MenuGrisos: TMenuItem;
    MenuEuskera: TMenuItem;
    MenuAtractor: TMenuItem;
    MenuGalego: TMenuItem;
    MenuPortugues: TMenuItem;
    N6: TMenuItem;
    MenuFonemes: TMenuItem;
    MenuEspectroscopiLPC: TMenuItem;
    N7: TMenuItem;
    MenuFrequencia: TMenuItem;
    MenuSonograma: TMenuItem;
    MenuEnglish: TMenuItem;
    MenuPlasma: TMenuItem;
    MenuFractal: TMenuItem;
    procedure MenuSortirClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure MenuIntensitatDuradaClick(Sender: TObject);
    procedure MenuEspectroscopiClick(Sender: TObject);
    procedure MenuGlobusClick(Sender: TObject);
    procedure MenuJocDelsRectanglesClick(Sender: TObject);
    procedure MenuArcdeSantMartiClick(Sender: TObject);
    procedure MenuViatgeAmbGlobusClick(Sender: TObject);
    procedure MenuCanviarParametresClick(Sender: TObject);
    procedure MenuFemMoureUnCotxeClick(Sender: TObject);
    procedure MenuParlantDeClick(Sender: TObject);
    procedure MenuCursaClick(Sender: TObject);
    procedure MenuXupaXupsClick(Sender: TObject);
    procedure MenuCatalaClick(Sender: TObject);
    procedure MenuCastellanoClick(Sender: TObject);
    procedure MenuGrisosClick(Sender: TObject);
    procedure MenuEuskeraClick(Sender: TObject);
    procedure MenuAtractorClick(Sender: TObject);
    procedure MenuGalegoClick(Sender: TObject);
    procedure MenuPortuguesClick(Sender: TObject);
    procedure MenuFonemesClick(Sender: TObject);
    procedure MenuEspectroscopiLPCClick(Sender: TObject);
    procedure MenuFrequenciaClick(Sender: TObject);
    procedure MenuSonogramaClick(Sender: TObject);
    procedure MenuEnglishClick(Sender: TObject);
    procedure MenuPlasmaClick(Sender: TObject);
    procedure MenuFractalClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
    Missatges:array[1..10]of string;
  end;

var
  FormPrincipal: TFormPrincipal;

{************************************************}
IMPLEMENTATION
{************************************************}

uses UnitFormIntensitatDurada, UnitEspectroscopi, UnitGlobus,
  UnitJocDelsRectangles, UnitArcDeSantMarti, UnitViatgeEnGlobus,
  UnitCanviDeParametres, UnitFemMoureUnCotxe, Unitabout, UnitCursa, UnitXupaXups, UnitEntradaSo,
  UnitGrisos, UnitAtractor, UnitReconeixementManualDeFonemes,
  UnitEspectroscopiLPC, UnitFormFrequencia, UnitFormSonograma, UnitFormPlasma,
  UnitFormFractal;

{$R *.DFM}

{************************************************}
procedure TFormPrincipal.FormCreate(Sender: TObject);
var
  x:integer;
  MyRect:TRect;
begin
  x:=GetSystemMetrics(SM_CXSCREEN);
  GetWindowRect(Handle, MyRect);
  with MyRect do SetWindowPos(Handle,0,x-((Right-Left)), 0,MyRect.Right, MyRect.Bottom, swp_NoSize or swp_NoZOrder);
  if not FileExists('plasma.exe') then MenuPlasma.Visible:=false;
end;

{************************************************}
procedure TFormPrincipal.MenuCanviarParametresClick(Sender: TObject);
begin
  FormCanviDeParametres.ShowModal;
end;

procedure TFormPrincipal.MenuSortirClick(Sender: TObject);
begin
  Close;
end;

{************************************************}
procedure TFormPrincipal.MenuIntensitatDuradaClick(Sender: TObject);
begin
  FormIntensitatDurada.ShowModal;
end;

procedure TFormPrincipal.MenuEspectroscopiClick(Sender: TObject);
begin
  FormEspectroscopi.ShowModal;
end;

procedure TFormPrincipal.MenuGlobusClick(Sender: TObject);
begin
  FormGlobus.ShowModal;
end;

procedure TFormPrincipal.MenuJocDelsRectanglesClick(Sender: TObject);
begin
  FormJocRectangles.ShowModal;
end;

procedure TFormPrincipal.MenuArcdeSantMartiClick(Sender: TObject);
begin
  FormArcDeSantMarti.ShowModal;
end;

procedure TFormPrincipal.MenuViatgeAmbGlobusClick(Sender: TObject);
begin
  FormViatgeEnGlobus.ShowModal;
end;

procedure TFormPrincipal.MenuFemMoureUnCotxeClick(Sender: TObject);
begin
  FormFemMoureUnCotxe.ShowModal;
end;

procedure TFormPrincipal.MenuParlantDeClick(Sender: TObject);
begin
  AboutBox.ShowModal;
end;

procedure TFormPrincipal.MenuCursaClick(Sender: TObject);
begin
  FormCursa.ShowModal;
end;

procedure TFormPrincipal.MenuXupaXupsClick(Sender: TObject);
begin
  FormXupaXups.ShowModal;
end;

procedure TFormPrincipal.MenuCatalaClick(Sender: TObject);
begin
  MenuCatala.Checked:=true;
  MenuCastellano.Checked:=false;
  MenuEuskera.Checked:=false;
  MenuGalego.Checked:=false;
  MenuPortugues.Checked:=false;
  MenuEnglish.Checked:=false;

  MenuFitxer.Caption:='&Fitxer';
  MenuLlengua.Caption:='Llengua';
  MenuCanviarParametres.Caption:='Canviar parmetres...';
  MenuSortir.Caption:='&Sortir';
  MenuQueVullFer.Caption:='&Qu vull fer?';
  MenuGlobus.Caption:='Globus';

  MenuGrisos.Caption:='Grisos';
  FormGrisos.RadioButtonBlanc.Caption:='Blanc';
  FormGrisos.RadioButtonVerd.Caption:='Verd';
  FormGrisos.RadioButtonBlau.Caption:='Blau';
  FormGrisos.RadioButtonVermell.Caption:='Vermell';
  FormGrisos.RadioButtonGroc.Caption:='Groc';

  MenuArcdeSantMarti.Caption:='Arc de Sant Mart';
  MenuJocDelsRectangles.Caption:='Joc dels rectangles';
  MenuViatgeAmbGlobus.Caption:='Viatge amb Globus';
  MenuXupaXups.Caption:='Xupa Xups';
  MenuIntensitatDurada.Caption:='&Intensitat durada';
  MenuFemMoureUnCotxe.Caption:='Fem moure un cotxe';
  MenuCursa.Caption:='Cursa';
  MenuEspectroscopi.Caption:='E&spectroscopi/Oscil.loscopi';
  MenuParlantDe.Caption:='Parlant &de...';

  FormCanviDeParametres.Caption:='Canvi de Parmetres';
  FormCanviDeParametres.Label1.Caption:='Valor Mxim :';
  FormCanviDeParametres.Label2.Caption:='Valor Mnim :';
  FormCanviDeParametres.Label3.Caption:='Increment X :';
  FormCanviDeParametres.BitBtnOK.Caption:='D''acord';
  FormCanviDeParametres.BitBtnCancel.Caption:='Cancel.lar';

  FormArcDeSantMarti.Caption:='Arc de Sant Mart';

  FormCursa.Caption:='Cursa';
  FormCursa.CheckBoxLiniesAlMateixLLoc.Caption:='Lnies al mateix lloc';

  FormIntensitatDurada.Caption:='Intensitat Durada';
  FormIntensitatDurada.CheckBoxLiniesAlMateixLLoc.Caption:=FormCursa.CheckBoxLiniesAlMateixLLoc.Caption;

  FormFemMoureUnCotxe.Caption:='Fem moure un cotxe';

  FormGlobus.Caption:='Globus';
  FormGlobus.CheckBoxDecibels.Caption:='Decibels';

  FormJocRectangles.Caption:='Joc dels rectangles';

  FormViatgeEnGlobus.Caption:='Viatge en globus';

  FormXupaXups.Caption:='Xupa Xups';
  FormXupaXups.CheckBoxLiniesAlMateixLLoc.Caption:=FormCursa.CheckBoxLiniesAlMateixLLoc.Caption;

  FormEspectroscopi.Caption:='Espectroscopi';
  FormEspectroscopi.CheckBoxLiniesAlMateixLLoc.Caption:='Lnies al mateix lloc';
  FormEspectroscopi.CheckBoxOsciloscopi.Caption:='Oscil.loscopi';
  FormEspectroscopi.CheckBoxEnvolvent.Caption:='Envolvent';

  MessageString1:='NO puc obrir el dispositiu d''entrada de so';
  MessageString2:='El valor mxim no pot ser ms gran que 128';
  MessageString3:='El valor mxim no pot ser ms petit que el valor mnim :';
  MessageString4:='El valor mnim no pot ser ms petit que 0';
  MessageString5:='El valor mnim no pot ser ms gran que el valor mxim :';
  MessageString6:='L''increment de X no pot ser ms petit que 1';
  MessageString7:='L''increment de X no pot ser ms gran que 16';

  FormEspectroscopi.CheckBoxCalculAutomaticFrequencia.Caption:='Clcul automtic freqncia';
  FormEspectroscopi.CheckBoxRapid.Caption:='Rpid';
  FormCanviDeParametres.BitBtnMicrofon.Caption:='Nivell &microfon';
  MenuFonemes.Caption:='Fonemes';
  FormReconeixementManualDeFonemes.CheckBoxGrandaria.Caption:='Grandaria fixa';
  MenuEspectroscopiLPC.Caption:='Comparaci de patrons';
  MenuSonograma.Caption:='Sonograma';
  MenuFrequencia.Caption:='Freqncia';
  FormEspectroscopiLPC.Caption:='Comparaci de patrons';
  FormEspectroscopiLPC.ButtonEsborrar.Caption:='Esborrar';
  FormEspectroscopiLPC.ButtonEsborrarUltim.Caption:='Esborrar ltim';
  FormEspectroscopiLPC.ButtonVocals.Caption:='Vocals';
  FormEspectroscopiLPC.ButtonCongelar.Caption:='Congelar';
  FormFrequencia.Caption:='Freqncia';
  FormFrequencia.CheckBoxEvolucio.Caption:='Evoluci';
  FormFrequencia.CheckBoxPosicioNotesMusicals.Caption:='Posici notes musicals';
  FormFrequencia.ButtonIniciarMaximMinim.Caption:='Iniciar Mxim/Mnim';
  FormFrequencia.CheckBoxEscalaLogaritmica.Caption:='Escala Logartmica';
  FormSonograma.Caption:='Sonograma';
  FormSonograma.CheckBoxCircular.Caption:='Circular';
  FormSonograma.CheckBoxEscalaY.Caption:='Eix Y mostrar escala de freqncies';
  FormReconeixementManualDeFonemes.Caption:='Fonemes';
  FormEspectroscopiLPC.CheckBoxNoRepintar.Caption:='No repintar';
  FormFractal.CheckBoxNoIniciar.Caption:='No iniciar';
  FormAtractor.CheckBoxNoIniciar.Caption:='No iniciar';
  FormSonograma.LabelVelocitat.Caption:='Velocitat';
  FormSonograma.LabelNumeroQuoeficientsLPC.Caption:='Nmero de quoeficients';
  FormEspectroscopiLPC.LabelNumeroQuoeficientsLPC.Caption:='Nm. quoeficients';
  Missatges[1]:='No puc obrir el fitxer o el fitxer no cont dades Globus-Sonograma';
  FormEspectroscopiLPC.CheckBoxMostrarSoReconegut.Caption:='Mostrar so reconegut';

  writePrivateProfileString('globus 3','Llengua','Catal','globus3.ini')
end;

procedure TFormPrincipal.MenuCastellanoClick(Sender: TObject);
begin
  MenuCatala.Checked:=false;
  MenuCastellano.Checked:=True;
  MenuEuskera.Checked:=false;
  MenuGalego.Checked:=false;
  MenuPortugues.Checked:=false;
  MenuEnglish.Checked:=false;

  MenuFitxer.Caption:='&Archivo';
  MenuLlengua.Caption:='Lengua';
  MenuCanviarParametres.Caption:='Cambiar parmetros...';
  MenuSortir.Caption:='&Salir';
  MenuQueVullFer.Caption:='&Qu quiero hacer?';
  MenuGlobus.Caption:='Globos';

  MenuGrisos.Caption:='Grises';
  FormGrisos.RadioButtonBlanc.Caption:='Blanco';
  FormGrisos.RadioButtonVerd.Caption:='Verde';
  FormGrisos.RadioButtonBlau.Caption:='Azul';
  FormGrisos.RadioButtonVermell.Caption:='Rojo';
  FormGrisos.RadioButtonGroc.Caption:='Amarillo';

  MenuArcdeSantMarti.Caption:='Arco ris';
  MenuJocDelsRectangles.Caption:='Juego de los rectngulos';
  MenuViatgeAmbGlobus.Caption:='Viaje en globo';
  MenuXupaXups.Caption:='Chupa Chups';
  MenuIntensitatDurada.Caption:='&Intensidad duracin';
  MenuFemMoureUnCotxe.Caption:='Movamos un coche';
  MenuCursa.Caption:='Carrera';
  MenuEspectroscopi.Caption:='E&spectroscopio/Osciloscopio';
  MenuParlantDe.Caption:='Acerca &de...';

  FormCanviDeParametres.Caption:='Cambio de parmetros';
  FormCanviDeParametres.Label1.Caption:='Valor Mximo :';
  FormCanviDeParametres.Label2.Caption:='Valor Mnimo :';
  FormCanviDeParametres.Label3.Caption:='Incremento X :';
  FormCanviDeParametres.BitBtnOK.Caption:='Aceptar';
  FormCanviDeParametres.BitBtnCancel.Caption:='Cancelar';

  FormArcDeSantMarti.Caption:='Arco ris';

  FormCursa.Caption:='Carrera';
  FormCursa.CheckBoxLiniesAlMateixLLoc.Caption:='Lneas en el mismo lugar';

  FormIntensitatDurada.Caption:='Intensidad Duracin';
  FormIntensitatDurada.CheckBoxLiniesAlMateixLLoc.Caption:=FormCursa.CheckBoxLiniesAlMateixLLoc.Caption;

  FormFemMoureUnCotxe.Caption:='Movamos un coche';

  FormGlobus.Caption:='Globos';
  FormGlobus.CheckBoxDecibels.Caption:='Decibelios';

  FormJocRectangles.Caption:='Juego de los rectngulos';

  FormViatgeEnGlobus.Caption:='Viaje en globo';

  FormXupaXups.Caption:='Chupa Chups';
  FormXupaXups.CheckBoxLiniesAlMateixLLoc.Caption:=FormCursa.CheckBoxLiniesAlMateixLLoc.Caption;

  FormEspectroscopi.Caption:='Espectroscopio';
  FormEspectroscopi.CheckBoxLiniesAlMateixLLoc.Caption:='Lneas en el mismo lugar';
  FormEspectroscopi.CheckBoxOsciloscopi.Caption:='Osciloscopio';
  FormEspectroscopi.CheckBoxEnvolvent.Caption:='Envolvente';

  MessageString1:='NO puedo abrir el dispositivo de entrada de sonido';
  MessageString2:='El valor mximo no puede se ms grande que 128';
  MessageString3:='El valor mximo no puede ser ms pequeo que el valor mnimo :';
  MessageString4:='El valor mnimo no puede ser ms pequeo que 0';
  MessageString5:='El valor mnimo no puede ser mayor que el valor mximo :';
  MessageString6:='El incremento de X no puede ser ms pequeo que 1';
  MessageString7:='El incremento de X no puede ser mayor que 16';

  FormEspectroscopi.CheckBoxCalculAutomaticFrequencia.Caption:='Clculo automtico frecuencia';
  FormEspectroscopi.CheckBoxRapid.Caption:='Rpido';
  FormCanviDeParametres.BitBtnMicrofon.Caption:='Nivel &micrfono';
  MenuFonemes.Caption:='Fonemas';
  FormReconeixementManualDeFonemes.CheckBoxGrandaria.Caption:='Tamao fijo';
  MenuEspectroscopiLPC.Caption:='Comparacin de patrones';
  MenuSonograma.Caption:='Sonograma';
  MenuFrequencia.Caption:='Frecuencia';
  FormEspectroscopiLPC.Caption:='Comparacin de patrones';
  FormEspectroscopiLPC.ButtonEsborrar.Caption:='Borrar';
  FormEspectroscopiLPC.ButtonEsborrarUltim.Caption:='Borrar ltima';
  FormEspectroscopiLPC.ButtonVocals.Caption:='Vocales';
  FormEspectroscopiLPC.ButtonCongelar.Caption:='Congelar';
  FormFrequencia.Caption:='Frecuencia';
  FormFrequencia.CheckBoxEvolucio.Caption:='Evolucin';
  FormFrequencia.CheckBoxPosicioNotesMusicals.Caption:='Posicin notas musicales';
  FormFrequencia.ButtonIniciarMaximMinim.Caption:='Iniciar Mximo/Mnimo';
  FormFrequencia.CheckBoxEscalaLogaritmica.Caption:='Escala Logartmica';
  FormSonograma.Caption:='Sonograma';
  FormSonograma.CheckBoxCircular.Caption:='Circular';
  FormSonograma.CheckBoxEscalaY.Caption:='Eje Y mostrar escala de frecuencias';
  FormReconeixementManualDeFonemes.Caption:='Fonemas';
  FormEspectroscopiLPC.CheckBoxNoRepintar.Caption:='No repintar';
  FormFractal.CheckBoxNoIniciar.Caption:='No iniciar';
  FormAtractor.CheckBoxNoIniciar.Caption:='No iniciar';
  FormSonograma.LabelVelocitat.Caption:='Velocidad';
  FormSonograma.LabelNumeroQuoeficientsLPC.Caption:='Nmero de coeficientes';
  FormEspectroscopiLPC.LabelNumeroQuoeficientsLPC.Caption:='Nm. coeficientes';
  Missatges[1]:='No puedo abrir el archivo o el archivo no contiene datos Globus-Sonograma';
  FormEspectroscopiLPC.CheckBoxMostrarSoReconegut.Caption:='Mostrar sonido';

  writePrivateProfileString('globus 3','Llengua','Castell','globus3.ini');
end;

procedure TFormPrincipal.MenuEuskeraClick(Sender: TObject);
begin
  MenuCatala.Checked:=false;
  MenuCastellano.Checked:=false;
  MenuEuskera.Checked:=true;
  MenuGalego.Checked:=false;
  MenuPortugues.Checked:=false;
  MenuEnglish.Checked:=false;

  MenuFitxer.Caption:='&Artxiboa';
  MenuLlengua.Caption:='Hizkuntza';
  MenuCanviarParametres.Caption:='Parametroak aldatu...';
  MenuSortir.Caption:='I&rten';
  MenuQueVullFer.Caption:='&Zer egin nahi duzu?';
  MenuGlobus.Caption:='Puxikak';

  MenuGrisos.Caption:='Grisak';
  FormGrisos.RadioButtonBlanc.Caption:='Zuria';
  FormGrisos.RadioButtonVerd.Caption:='Berdea';
  FormGrisos.RadioButtonBlau.Caption:='Urdina';
  FormGrisos.RadioButtonVermell.Caption:='Gorria';
  FormGrisos.RadioButtonGroc.Caption:='Horia';

  MenuArcdeSantMarti.Caption:='Ortzadarra';
  MenuJocDelsRectangles.Caption:='Laukien jokua';
  MenuViatgeAmbGlobus.Caption:='Globoz bidaiatu';
  MenuXupaXups.Caption:='Txupa txusak';
  MenuIntensitatDurada.Caption:='&Sakontasuna iraupena';
  MenuFemMoureUnCotxe.Caption:='Kotxea mugitu';
  MenuCursa.Caption:='Lasterketa';
  MenuEspectroscopi.Caption:='E&spektroskopioa/Osciloscopio';
  MenuParlantDe.Caption:='&Zeri buruz...';

  FormCanviDeParametres.Caption:='Parametroetako aldaketa';
  FormCanviDeParametres.Label1.Caption:='Gehienezko balioa:';
  FormCanviDeParametres.Label2.Caption:='Gutxienezko balioa :';
  FormCanviDeParametres.Label3.Caption:='Gehikuntza X :';
  FormCanviDeParametres.BitBtnOK.Caption:='Onartu';
  FormCanviDeParametres.BitBtnCancel.Caption:='Ezeztatu';

  FormArcDeSantMarti.Caption:='Ortzadarra';

  FormCursa.Caption:='Lasterketa';
  FormCursa.CheckBoxLiniesAlMateixLLoc.Caption:='Lerroak leku berean';

  FormIntensitatDurada.Caption:='Sakontasuna Iraupena';
  FormIntensitatDurada.CheckBoxLiniesAlMateixLLoc.Caption:=FormCursa.CheckBoxLiniesAlMateixLLoc.Caption;

  FormFemMoureUnCotxe.Caption:='Kotxea mugitu';

  FormGlobus.Caption:='Puxikak';
  FormGlobus.CheckBoxDecibels.Caption:='Dezibelioak';

  FormJocRectangles.Caption:='Laukien jokua';

  FormViatgeEnGlobus.Caption:='Globoz bidaiatu';

  FormXupaXups.Caption:='Txupa txusak';
  FormXupaXups.CheckBoxLiniesAlMateixLLoc.Caption:=FormCursa.CheckBoxLiniesAlMateixLLoc.Caption;

  FormEspectroscopi.Caption:='Espektroskopioa';
  FormEspectroscopi.CheckBoxLiniesAlMateixLLoc.Caption:='Lerroak leku berean';
  FormEspectroscopi.CheckBoxOsciloscopi.Caption:='Osziloskopioa';
  FormEspectroscopi.CheckBoxEnvolvent.Caption:='Inguratzailea';

  MessageString1:='EZIN dut soinuaren sarbidea ireki';
  MessageString2:='Gehienezko balioak ezin du 128 baino altuagoa izan';
  MessageString3:='Gehienezko baioak ezin du gutxienezkoa baino txikiagoa izan:';
  MessageString4:='Gutxienezko balioak ezin du 0 baino txikiagoa izan';
  MessageString5:='Gutxienezko balioa gehienezkoa baino altuagoa izan daiteke :';
  MessageString6:='X-en gehikuntzak ezin du 1 baino txikiagoa izan';
  MessageString7:='X-en gehikuntzak ezin du 16 baino altuagoa izan';

  FormEspectroscopi.CheckBoxCalculAutomaticFrequencia.Caption:='Kalkulu automatikoa maiztasuna';
  FormEspectroscopi.CheckBoxRapid.Caption:='Arin';
  FormCanviDeParametres.BitBtnMicrofon.Caption:='Maila &mikrofonoa';
  MenuFonemes.Caption:='Fonemak';
  FormReconeixementManualDeFonemes.CheckBoxGrandaria.Caption:='Neurri finkoa';
  MenuEspectroscopiLPC.Caption:='Patroiak alderatu';
  MenuSonograma.Caption:='Soinugrama';
  MenuFrequencia.Caption:='Maiztasuna';
  FormEspectroscopiLPC.Caption:='Patroiak alderatu';
  FormEspectroscopiLPC.ButtonEsborrar.Caption:='Ezabatu';
  FormEspectroscopiLPC.ButtonEsborrarUltim.Caption:='Azkena ezabatu';
  FormEspectroscopiLPC.ButtonVocals.Caption:='Bokalak';
  FormEspectroscopiLPC.ButtonCongelar.Caption:='Gelditu';
  FormFrequencia.Caption:='Maiztasuna';
  FormFrequencia.CheckBoxEvolucio.Caption:='Bilakaera';
  FormFrequencia.CheckBoxPosicioNotesMusicals.Caption:='Musika notentzako modua';
  FormFrequencia.ButtonIniciarMaximMinim.Caption:='Gehien/Gutxien hasi';
  FormFrequencia.CheckBoxEscalaLogaritmica.Caption:='Eskala Logartmikoa';
  FormSonograma.Caption:='Soinugrama';
  FormSonograma.CheckBoxCircular.Caption:='Mugitu';
  FormSonograma.CheckBoxEscalaY.Caption:='Y ardatza maiztasun eskala azaldu';
  FormReconeixementManualDeFonemes.Caption:='Fonemak';
  FormEspectroscopiLPC.CheckBoxNoRepintar.Caption:='Ez margotu berriro';
  FormFractal.CheckBoxNoIniciar.Caption:='Ez hasi';
  FormAtractor.CheckBoxNoIniciar.Caption:='Ez hasi';
  FormSonograma.LabelVelocitat.Caption:='Abiadura';
  FormSonograma.LabelNumeroQuoeficientsLPC.Caption:='Koefiziente kopurua';
  FormEspectroscopiLPC.LabelNumeroQuoeficientsLPC.Caption:='Koefiziente kopurua';
  Missatges[1]:='Ezin dut artxiboa ireki edo artxiboak ez du "Globus-soinugrama"-rako daturik';
  FormEspectroscopiLPC.CheckBoxMostrarSoReconegut.Caption:='Soinua azaldu';

  writePrivateProfileString('globus 3','Llengua','Euskera','globus3.ini');
end;

procedure TFormPrincipal.MenuGalegoClick(Sender: TObject);
begin
  MenuCatala.Checked:=false;
  MenuCastellano.Checked:=false;
  MenuEuskera.Checked:=false;
  MenuGalego.Checked:=true;
  MenuPortugues.Checked:=false;
  MenuEnglish.Checked:=false;

  MenuFitxer.Caption:='&Arquivo';
  MenuLlengua.Caption:='Lingua';
  MenuCanviarParametres.Caption:='Cambiar parmetros...';
  MenuSortir.Caption:='&Sar';
  MenuQueVullFer.Caption:='&Que quero facer?';
  MenuGlobus.Caption:='Globos';

  MenuGrisos.Caption:='Grises';
  FormGrisos.RadioButtonBlanc.Caption:='Branco';
  FormGrisos.RadioButtonVerd.Caption:='Verde';
  FormGrisos.RadioButtonBlau.Caption:='Azul';
  FormGrisos.RadioButtonVermell.Caption:='Vermello';
  FormGrisos.RadioButtonGroc.Caption:='Amarelo';
 
  MenuArcdeSantMarti.Caption:='Arco da vella';
  MenuJocDelsRectangles.Caption:='Xogo dos rectngulos';
  MenuViatgeAmbGlobus.Caption:='Viaxe en globo';
  MenuXupaXups.Caption:='Chupa Chups';
  MenuIntensitatDurada.Caption:='&Intensidade duracin';
  MenuFemMoureUnCotxe.Caption:='Movamos un autombil';
  MenuCursa.Caption:='Carreira';
  MenuEspectroscopi.Caption:='E&spectroscopio/Osciloscopio';
  MenuParlantDe.Caption:='Acerca &de...';
 
  FormCanviDeParametres.Caption:='Cambio de parmetros';
  FormCanviDeParametres.Label1.Caption:='Valor Mximo :';
  FormCanviDeParametres.Label2.Caption:='Valor Mnimo :';
  FormCanviDeParametres.Label3.Caption:='Incremento X :';
  FormCanviDeParametres.BitBtnOK.Caption:='Aceptar';
  FormCanviDeParametres.BitBtnCancel.Caption:='Cancelar';

  FormArcDeSantMarti.Caption:='Arco da vella';
 
  FormCursa.Caption:='Carreira';
  FormCursa.CheckBoxLiniesAlMateixLLoc.Caption:='Lias no mesmo lugar';
 
  FormIntensitatDurada.Caption:='Intensidade Duracin';
  FormIntensitatDurada.CheckBoxLiniesAlMateixLLoc.Caption:=FormCursa.CheckBoxLiniesAlMateixLLoc.Caption;
 
  FormFemMoureUnCotxe.Caption:='Movamos un autombil';
 
  FormGlobus.Caption:='Globos';
  FormGlobus.CheckBoxDecibels.Caption:='Decibelios';
 
  FormJocRectangles.Caption:='Xogo dos rectngulos';
 
  FormViatgeEnGlobus.Caption:='Viaxe en globo';
 
  FormXupaXups.Caption:='Chupa Chups';
  FormXupaXups.CheckBoxLiniesAlMateixLLoc.Caption:=FormCursa.CheckBoxLiniesAlMateixLLoc.Caption;

  FormEspectroscopi.Caption:='Espectroscopio';
  FormEspectroscopi.CheckBoxLiniesAlMateixLLoc.Caption:='Lias no mesmo lugar';
  FormEspectroscopi.CheckBoxOsciloscopi.Caption:='Osciloscopio';
  FormEspectroscopi.CheckBoxEnvolvent.Caption:='Envolvente';

  MessageString1:='Non podo abri-lo dispositivo de entrada de son';
  MessageString2:='O valor mximo non pode ser mis grande que 128';
  MessageString3:='O valor mximo non pode ser mis pequeno c valor mnimo :';
  MessageString4:='O valor mnimo non pode ser mis pequeno que 0';
  MessageString5:='O valor mnimo non pode ser maior c valor mximo :';
  MessageString6:='O incremento de X non pode ser mis pequeno que 1';
  MessageString7:='O incremento de X non pode ser maior ca 16';

  FormEspectroscopi.CheckBoxCalculAutomaticFrequencia.Caption:='Clculo automtico frecuencia';
  FormEspectroscopi.CheckBoxRapid.Caption:='Rpido';
  FormCanviDeParametres.BitBtnMicrofon.Caption:='Nivel &micrfono';
  MenuFonemes.Caption:='Fonemas';
  FormReconeixementManualDeFonemes.CheckBoxGrandaria.Caption:='Tamao fixo';
  MenuEspectroscopiLPC.Caption:='Comparacin de modelos';
  MenuSonograma.Caption:='Sonograma';
  MenuFrequencia.Caption:='Frecuencia';
  FormEspectroscopiLPC.Caption:='Comparacin de modelos';
  FormEspectroscopiLPC.ButtonEsborrar.Caption:='Borrar';
  FormEspectroscopiLPC.ButtonEsborrarUltim.Caption:='Borrar ltima';
  FormEspectroscopiLPC.ButtonVocals.Caption:='Vogais';
  FormEspectroscopiLPC.ButtonCongelar.Caption:='Conxelar';
  FormFrequencia.Caption:='Frecuencia';
  FormFrequencia.CheckBoxEvolucio.Caption:='Evolucin';
  FormFrequencia.CheckBoxPosicioNotesMusicals.Caption:='Posicin notas musicais';
  FormFrequencia.ButtonIniciarMaximMinim.Caption:='Iniciar Mximo/Mnimo';
  FormFrequencia.CheckBoxEscalaLogaritmica.Caption:='Escala Logartmica';
  FormSonograma.Caption:='Sonograma';
  FormSonograma.CheckBoxCircular.Caption:='Circular';
  FormSonograma.CheckBoxEscalaY.Caption:='Eixe Y mostrar escala de frecuencias';
  FormReconeixementManualDeFonemes.Caption:='Fonemas';
  FormEspectroscopiLPC.CheckBoxNoRepintar.Caption:='Non repintar';
  FormFractal.CheckBoxNoIniciar.Caption:='Non iniciar';
  FormAtractor.CheckBoxNoIniciar.Caption:='Non iniciar';
  FormSonograma.LabelVelocitat.Caption:='Velocidade';
  FormSonograma.LabelNumeroQuoeficientsLPC.Caption:='Nmero de coeficientes';
  FormEspectroscopiLPC.LabelNumeroQuoeficientsLPC.Caption:='Nmero de coeficientes';
  Missatges[1]:='Non podo abrir o arquivo ou o arquivo non contn datos Globus-Sonograma';
  FormEspectroscopiLPC.CheckBoxMostrarSoReconegut.Caption:='Mostrar son';

  writePrivateProfileString('globus 3','Llengua','Galego','globus3.ini');
end;

procedure TFormPrincipal.MenuPortuguesClick(Sender: TObject);
begin
  MenuCatala.Checked:=false;
  MenuCastellano.Checked:=false;
  MenuEuskera.Checked:=false;
  MenuGalego.Checked:=false;
  MenuPortugues.Checked:=true;
  MenuEnglish.Checked:=false;

  MenuFitxer.Caption:='&Ficheiro';
  MenuLlengua.Caption:='Linguagem';
  MenuCanviarParametres.Caption:='Trocar parmetros...';
  MenuSortir.Caption:='&Sair';
  MenuQueVullFer.Caption:='&Que quero fazer?';
  MenuGlobus.Caption:='Balos';
 
  MenuGrisos.Caption:='Cinzentos';
  FormGrisos.RadioButtonBlanc.Caption:='Branco';
  FormGrisos.RadioButtonVerd.Caption:='Verde';
  FormGrisos.RadioButtonBlau.Caption:='Azul';
  FormGrisos.RadioButtonVermell.Caption:='Rojo';
  FormGrisos.RadioButtonGroc.Caption:='Amarelo';
 
  MenuArcdeSantMarti.Caption:='Arco-ris';
  MenuJocDelsRectangles.Caption:='Jogo dos retngulos';
  MenuViatgeAmbGlobus.Caption:='Viagem en balo';
  MenuXupaXups.Caption:='Chupa Chups';
  MenuIntensitatDurada.Caption:='&Intensidade durao';
  MenuFemMoureUnCotxe.Caption:='Movamos um carro';
  MenuCursa.Caption:='Carreira';
  MenuEspectroscopi.Caption:='E&spectroscpio/Osciloscopio';
  MenuParlantDe.Caption:='Cerca &de...';
 
  FormCanviDeParametres.Caption:='Cmbio de parmetros';
  FormCanviDeParametres.Label1.Caption:='Valor Mximo :';
  FormCanviDeParametres.Label2.Caption:='Valor Mnimo :';
  FormCanviDeParametres.Label3.Caption:='Incremento X :';
  FormCanviDeParametres.BitBtnOK.Caption:='Aceitar';
  FormCanviDeParametres.BitBtnCancel.Caption:='Anular';

  FormArcDeSantMarti.Caption:='Arco-ris';
 
  FormCursa.Caption:='Carreira';
  FormCursa.CheckBoxLiniesAlMateixLLoc.Caption:='Linhas no mesmo lugar';
 
  FormIntensitatDurada.Caption:='Intensidade Durao';
  FormIntensitatDurada.CheckBoxLiniesAlMateixLLoc.Caption:=FormCursa.CheckBoxLiniesAlMateixLLoc.Caption;
 
  FormFemMoureUnCotxe.Caption:='Movamos um carro';
 
  FormGlobus.Caption:='Balos';
  FormGlobus.CheckBoxDecibels.Caption:='Decibis';
 
  FormJocRectangles.Caption:='Jogo dos retngulos';
 
  FormViatgeEnGlobus.Caption:='Viagem en balo';
 
  FormXupaXups.Caption:='Chupa Chups';
  FormXupaXups.CheckBoxLiniesAlMateixLLoc.Caption:=FormCursa.CheckBoxLiniesAlMateixLLoc.Caption;

  FormEspectroscopi.Caption:='Espectroscpio';
  FormEspectroscopi.CheckBoxLiniesAlMateixLLoc.Caption:='Linhas no mesmo lugar';
  FormEspectroscopi.CheckBoxOsciloscopi.Caption:='Osciloscpio';
  FormEspectroscopi.CheckBoxEnvolvent.Caption:='Envolvente';
 
  MessageString1:=' No posso abrir o dispositivo de entrada de som';
  MessageString2:='O valor mximo no pode ser superior a 128';
  MessageString3:='O valor mximo no pode ser inferior ao valor mnimo:';
  MessageString4:='O valor mnimo no pode ser inferior a 0';
  MessageString5:='O valor mnimo no pode ser maior que o valor mximo :';
  MessageString6:='O incremento de X no pode ser inferior a 1';
  MessageString7:='O incremento de X no pode ser superior a 16';

  FormEspectroscopi.CheckBoxCalculAutomaticFrequencia.Caption:='Clculo automtico frequncia';
  FormEspectroscopi.CheckBoxRapid.Caption:='Rpido';
  FormCanviDeParametres.BitBtnMicrofon.Caption:='Nvel &microfone';
  MenuFonemes.Caption:='Fonemas';
  FormReconeixementManualDeFonemes.CheckBoxGrandaria.Caption:='Tamanho fixo';
  MenuEspectroscopiLPC.Caption:='Comparao de modelos';
  MenuSonograma.Caption:='Sonograma';
  MenuFrequencia.Caption:='Frequncia';
  FormFrequencia.Caption:='Frequncia';
  FormEspectroscopiLPC.Caption:='Comparao de modelos';
  FormEspectroscopiLPC.ButtonEsborrar.Caption:='Apagar';
  FormEspectroscopiLPC.ButtonEsborrarUltim.Caption:='Apagar ltima';
  FormEspectroscopiLPC.ButtonVocals.Caption:='Vogais';
  FormEspectroscopiLPC.ButtonCongelar.Caption:='Congelar';
  FormFrequencia.CheckBoxEvolucio.Caption:='Evoluo';
  FormFrequencia.CheckBoxPosicioNotesMusicals.Caption:='Posio notas musicais';
  FormFrequencia.ButtonIniciarMaximMinim.Caption:='Iniciar Mximo/Mnimo';
  FormFrequencia.CheckBoxEscalaLogaritmica.Caption:='Escala Logartmica';
  FormSonograma.Caption:='Sonograma';
  FormSonograma.CheckBoxCircular.Caption:='Circular';
  FormSonograma.CheckBoxEscalaY.Caption:='Eixo Y mostrar escala de frequncias';
  FormReconeixementManualDeFonemes.Caption:='Fonemas';
  FormEspectroscopiLPC.CheckBoxNoRepintar.Caption:='No repintar';
  FormFractal.CheckBoxNoIniciar.Caption:='No iniciar';
  FormAtractor.CheckBoxNoIniciar.Caption:='No iniciar';
  FormSonograma.LabelVelocitat.Caption:='Velocidade';
  FormSonograma.LabelNumeroQuoeficientsLPC.Caption:='Nmero de coeficientes';
  FormEspectroscopiLPC.LabelNumeroQuoeficientsLPC.Caption:='Nmero de coeficientes';
  Missatges[1]:='No posso abrir o arquivo ou o arquivo no contm dados Globus-Sonograma';
  FormEspectroscopiLPC.CheckBoxMostrarSoReconegut.Caption:='Mostrar som';

  writePrivateProfileString('globus 3','Llengua','Portugues','globus3.ini');
end;

procedure TFormPrincipal.MenuEnglishClick(Sender: TObject);
begin
  MenuCatala.Checked:=false;
  MenuCastellano.Checked:=false;
  MenuEuskera.Checked:=false;
  MenuGalego.Checked:=false;
  MenuPortugues.Checked:=false;
  MenuEnglish.Checked:=true;

  MenuFitxer.Caption:='&File';
  MenuLlengua.Caption:='Language';
  MenuCanviarParametres.Caption:='Change parameters...';
  MenuSortir.Caption:='&Exit';
  MenuQueVullFer.Caption:='&What do I want to do?';
  MenuGlobus.Caption:='Globes';

  MenuGrisos.Caption:='Gray';
  FormGrisos.RadioButtonBlanc.Caption:='White';
  FormGrisos.RadioButtonVerd.Caption:='Green';
  FormGrisos.RadioButtonBlau.Caption:='Blue';
  FormGrisos.RadioButtonVermell.Caption:='Red';
  FormGrisos.RadioButtonGroc.Caption:='Yellow';

  MenuArcdeSantMarti.Caption:='Rainbow';
  MenuJocDelsRectangles.Caption:='Rectangles game';
  MenuViatgeAmbGlobus.Caption:='Globe trip';
  MenuXupaXups.Caption:='Chupa Chups';
  MenuIntensitatDurada.Caption:='&Intensity duration';
  MenuFemMoureUnCotxe.Caption:='Move a car';
  MenuCursa.Caption:='Race';
  MenuEspectroscopi.Caption:='&Spectroscope/Osciloscope';
  MenuParlantDe.Caption:='About...';

  FormCanviDeParametres.Caption:='Change parameters';
  FormCanviDeParametres.Label1.Caption:='Maximum value :';
  FormCanviDeParametres.Label2.Caption:='Minimum value :';
  FormCanviDeParametres.Label3.Caption:='Increment X :';
  FormCanviDeParametres.BitBtnOK.Caption:='OK';
  FormCanviDeParametres.BitBtnCancel.Caption:='Cancel';

  FormArcDeSantMarti.Caption:='Rainbow';

  FormCursa.Caption:='Race';
  FormCursa.CheckBoxLiniesAlMateixLLoc.Caption:='Lines at the same place';

  FormIntensitatDurada.Caption:='Intensity duration';
  FormIntensitatDurada.CheckBoxLiniesAlMateixLLoc.Caption:=FormCursa.CheckBoxLiniesAlMateixLLoc.Caption;

  FormFemMoureUnCotxe.Caption:='Move a car';

  FormGlobus.Caption:='Globes';
  FormGlobus.CheckBoxDecibels.Caption:='Decibels';

  FormJocRectangles.Caption:='Rectangles game';

  FormViatgeEnGlobus.Caption:='Globe trip';

  FormXupaXups.Caption:='Chupa Chups';
  FormXupaXups.CheckBoxLiniesAlMateixLLoc.Caption:=FormCursa.CheckBoxLiniesAlMateixLLoc.Caption;

  FormEspectroscopi.Caption:='Spectroscope';
  FormEspectroscopi.CheckBoxLiniesAlMateixLLoc.Caption:=FormCursa.CheckBoxLiniesAlMateixLLoc.Caption;
  FormEspectroscopi.CheckBoxOsciloscopi.Caption:='Osciloscope';
  FormEspectroscopi.CheckBoxEnvolvent.Caption:='Enveloping';

  MessageString1:='Can''t open the input sound device';
  MessageString2:='Maximum value can''t be greater than 128';
  MessageString3:='Minimum value can''t be smaller than minimum value:';
  MessageString4:='Minimum value can''t be smaller than 0';
  MessageString5:='Minimum value can''t be greater than maximum value :';
  MessageString6:='Increment of X can''t be smaller than 1';
  MessageString7:='Increment of X can''t be greater than 16';

  FormEspectroscopi.CheckBoxCalculAutomaticFrequencia.Caption:='Automatic calculation of frequency';
  FormEspectroscopi.CheckBoxRapid.Caption:='Fast';
  FormCanviDeParametres.BitBtnMicrofon.Caption:='&Microphone level';
  MenuFonemes.Caption:='Phonemes';
  FormReconeixementManualDeFonemes.CheckBoxGrandaria.Caption:='Fixed size';
  MenuEspectroscopiLPC.Caption:='Patron comparison';
  FormEspectroscopiLPC.Caption:=MenuEspectroscopiLPC.Caption;
  MenuSonograma.Caption:='Sonogram';
  MenuFrequencia.Caption:='Frequency';
  FormEspectroscopiLPC.ButtonEsborrar.Caption:='Erase';
  FormEspectroscopiLPC.ButtonEsborrarUltim.Caption:='Delete last';
  FormEspectroscopiLPC.ButtonVocals.Caption:='Vocals';
  FormEspectroscopiLPC.ButtonCongelar.Caption:='Freeze';
  FormFrequencia.Caption:='Frequency';
  FormFrequencia.CheckBoxEvolucio.Caption:='Evolution';
  FormFrequencia.CheckBoxPosicioNotesMusicals.Caption:='Musical note position';
  FormFrequencia.ButtonIniciarMaximMinim.Caption:='Initiate Maximum/Minimum';
  FormFrequencia.CheckBoxEscalaLogaritmica.Caption:='Logarithmic scale';
  FormSonograma.Caption:='Sonogram';
  FormSonograma.CheckBoxCircular.Caption:='Circular';
  FormSonograma.CheckBoxEscalaY.Caption:='Axis Y show frequency scale';
  FormReconeixementManualDeFonemes.Caption:='Phonemes';
  FormEspectroscopiLPC.CheckBoxNoRepintar.Caption:='Don''t redraw';
  FormFractal.CheckBoxNoIniciar.Caption:='Don''t initiate';
  FormAtractor.CheckBoxNoIniciar.Caption:='Don''t initiate';
  FormSonograma.LabelVelocitat.Caption:='Velocity';
  FormSonograma.LabelNumeroQuoeficientsLPC.Caption:='Number of coefficients';
  FormEspectroscopiLPC.LabelNumeroQuoeficientsLPC.Caption:='Num. coefficients';
  Missatges[1]:='Can''t open the file or the file doesn''t contain Globus-Sonograma data';
  FormEspectroscopiLPC.CheckBoxMostrarSoReconegut.Caption:='Show sound';

  writePrivateProfileString('globus 3','Llengua','English','globus3.ini');
end;

procedure TFormPrincipal.MenuGrisosClick(Sender: TObject);
begin
  FormGrisos.ShowModal;
end;

procedure TFormPrincipal.MenuAtractorClick(Sender: TObject);
begin
  FormAtractor.ShowModal;
end;

procedure TFormPrincipal.MenuFonemesClick(Sender: TObject);
begin
  FormReconeixementManualDeFonemes.ShowModal;
end;

procedure TFormPrincipal.MenuEspectroscopiLPCClick(Sender: TObject);
begin
  FormEspectroscopiLPC.ShowModal;
end;

procedure TFormPrincipal.MenuFrequenciaClick(Sender: TObject);
begin
  FormFrequencia.ShowModal;
end;

procedure TFormPrincipal.MenuSonogramaClick(Sender: TObject);
begin
  FormSonograma.ShowModal;
end;

procedure TFormPrincipal.MenuPlasmaClick(Sender: TObject);
begin
  FormPlasma.ShowModal;
end;

procedure TFormPrincipal.MenuFractalClick(Sender: TObject);
begin
  FormFractal.ShowModal;
end;

end.
